/**
* Script: textstate.js
* Written by: Radnen
* Updated: 12/21/2010
**/

function TextState(text, name) {
	if (!name) name = "TextState";
	this.inherit = State;
	this.inherit(name);
	
	this.x = SW/2-200;
	this.y = SH/2-120;
	this.text = text;
	
	this.onOkay = new Event(this);
	
	this.okaybutton = new EasyButton("Okay", this.x+180, this.y+204);
	this.okaybutton.onClick.add(function(sender) {
		sender.hide();
		sender.onOkay.execute();
	}, this);	

	this.render.add(function() {
		Rectangle(this.x, this.y, 400, 240, Colors.black);
		OutlinedRectangle(this.x, this.y, 400, 240, Colors.gray);
		System.textFont.drawTextBox(this.x+4, this.y+4, 392, 200, 0, this.text);
		this.okaybutton.draw();
	});
	
	this.update.add(function() {
		this.okaybutton.update();
	});
}